/*
 * Decompiled with CFR 0.152.
 */
package com.android.files.domain.util;

import com.android.files.domain.model.FileData;
import com.android.files.domain.util.AndroidFilesHandler;
import com.android.files.domain.util.FileIdData;
import com.utility.GetIdentity;
import com.utility.TncJdbc;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.springframework.core.io.Resource;
import org.springframework.web.multipart.MultipartFile;

public interface BinaryDataService {
    public static final String FILE_EXTENSION = ".png";

    public long store(MultipartFile var1, AndroidFilesHandler.PictureType var2) throws IOException;

    public Resource loadAsResource(String var1);

    public List<String> loadAllAsBase64(String var1);

    public long getSize(FileData var1);

    default public FileIdData getSrcIdCode(String fileId) {
        return new FileIdData(fileId);
    }

    default public void updatePath(MultipartFile file, AndroidFilesHandler.PictureType type, TncJdbc jdbc) throws IOException {
        long id = GetIdentity.invoke((TncJdbc)jdbc);
        AndroidFilesHandler androidFilesHandler = new AndroidFilesHandler(jdbc.getLogin(), type);
        File savedFile = androidFilesHandler.saveFile(file);
        jdbc.update("UPDATE HloPictures SET PicturePath = ? WHERE ID = ?", new Object[]{savedFile.getCanonicalPath(), id});
    }
}

